local labels = {
	SortOrder_Group				= 'Group',
	SortOrder_Title				= 'Songs by Alphabet',
	SortOrder_BPM				= 'BPM range',
	SortOrder_TopGrades			= 'Grade',
	SortOrder_Artist			= 'Artists by Alphabet',
	SortOrder_Genre				= 'Genre',
	SortOrder_EasyMeter			= 'Easy Difficulty',
	SortOrder_MediumMeter		= 'Medium Difficulty',
	SortOrder_HardMeter			= 'Hard Difficulty',
	SortOrder_ChallengeMeter	= 'Expert Difficulty',
	SortOrder_ModeMenu			= 'Sort by'
};

local t = Def.ActorFrame{
	Name="WheelItemSectionNormal";

	LoadActor( THEME:GetPathB("","_frame 3x3"), "_rounded blackinset transparent header", 256, 24)..{
		Name="SectionBG";
		SetMessageCommand=function(self,params)
			if params.SongGroup ~= "" or GAMESTATE:GetSortOrder() == 'SortOrder_ModeMenu' then self:visible(true)
			else self:visible(false);
			end;

			-- color based on song group
			local group = params.SongGroup;
			if group and GAMESTATE:GetSortOrder() == 'SortOrder_Group' then
				if group ~= "" and group ~= "N/A" then
					self:diffuse( SONGMAN:GetSongGroupColor(group) );
				else
					self:diffuse( color("1,1,1,1") );
				end;
			else
				self:diffuse( color("1,1,1,1") );
			end;

			-- xxx: color for other sorts?
		end;
	};

	Def.ActorFrame{
		Name="RouletteItem";
		SetMessageCommand=function(self,params)
			if params.SongGroup == "" and GAMESTATE:GetSortOrder() ~= 'SortOrder_ModeMenu' then
				self:visible(true)
			else
				self:visible(false);
			end;

			self:GetParent():GetChild("SectionLabel"):settext("");
		end;

		LoadActor( THEME:GetPathB("","_frame 3x3"), "_rounded blackinset transparent normal", 256, 24)..{
			Name="RouletteBG";
		};
	};
	AutoText("frutiger",true)..{
		Name="SectionLabel";
		InitCommand=cmd(x,-132;y,-18;horizalign,left;zoom,0.45;shadowlength,0;diffuse,color("#000000");strokecolor,color("0,0,0,0"));
		OnCommand=cmd(playcommand,"Set");
		SortOrderChangedMessageCommand=cmd(playcommand,"Set");
		SetCommand=function(self)
			local sort = GAMESTATE:GetSortOrder();
			local text;

			if not labels[sort] then text = "";
			else text = labels[sort];
			end;
			self:settext( text );
		end;

		SetMessageCommand=function(self,params)
			-- roulette hack!
			local sort = GAMESTATE:GetSortOrder();
			local text;

			if not params then
				return;
			end;
			if params.SongGroup == "" and sort ~= 'SortOrder_ModeMenu' then
				text = "";
			else
				if not labels[sort] then text = "";
				else text = labels[sort];
				end;
			end;
			self:settext( text );
		end;
	};
};

return t;